package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetEbsEncryptionByDefaultRequest(
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetEbsEncryptionByDefaultRequest = {
    import GetEbsEncryptionByDefaultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetEbsEncryptionByDefaultRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetEbsEncryptionByDefaultRequest.ReadOnly =
    zio.aws.ec2.model.GetEbsEncryptionByDefaultRequest.wrap(buildAwsValue())
}
object GetEbsEncryptionByDefaultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetEbsEncryptionByDefaultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetEbsEncryptionByDefaultRequest =
      zio.aws.ec2.model
        .GetEbsEncryptionByDefaultRequest(dryRun.map(value => value))
    def dryRun: Optional[Boolean]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetEbsEncryptionByDefaultRequest
  ) extends zio.aws.ec2.model.GetEbsEncryptionByDefaultRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetEbsEncryptionByDefaultRequest
  ): zio.aws.ec2.model.GetEbsEncryptionByDefaultRequest.ReadOnly = new Wrapper(
    impl
  )
}
