package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDefaultCreditSpecificationRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    instanceFamily: zio.aws.ec2.model.UnlimitedSupportedInstanceFamily
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetDefaultCreditSpecificationRequest = {
    import GetDefaultCreditSpecificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetDefaultCreditSpecificationRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .instanceFamily(instanceFamily.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetDefaultCreditSpecificationRequest.ReadOnly =
    zio.aws.ec2.model.GetDefaultCreditSpecificationRequest.wrap(buildAwsValue())
}
object GetDefaultCreditSpecificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetDefaultCreditSpecificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetDefaultCreditSpecificationRequest =
      zio.aws.ec2.model.GetDefaultCreditSpecificationRequest(
        dryRun.map(value => value),
        instanceFamily
      )
    def dryRun: Optional[Boolean]
    def instanceFamily: zio.aws.ec2.model.UnlimitedSupportedInstanceFamily
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getInstanceFamily: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.UnlimitedSupportedInstanceFamily
    ] = ZIO.succeed(instanceFamily)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetDefaultCreditSpecificationRequest
  ) extends zio.aws.ec2.model.GetDefaultCreditSpecificationRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val instanceFamily
        : zio.aws.ec2.model.UnlimitedSupportedInstanceFamily =
      zio.aws.ec2.model.UnlimitedSupportedInstanceFamily
        .wrap(impl.instanceFamily())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetDefaultCreditSpecificationRequest
  ): zio.aws.ec2.model.GetDefaultCreditSpecificationRequest.ReadOnly =
    new Wrapper(impl)
}
