package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetConsoleScreenshotRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    instanceId: InstanceId,
    wakeUp: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotRequest = {
    import GetConsoleScreenshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(wakeUp.map(value => value: java.lang.Boolean))(_.wakeUp)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetConsoleScreenshotRequest.ReadOnly =
    zio.aws.ec2.model.GetConsoleScreenshotRequest.wrap(buildAwsValue())
}
object GetConsoleScreenshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetConsoleScreenshotRequest =
      zio.aws.ec2.model.GetConsoleScreenshotRequest(
        dryRun.map(value => value),
        instanceId,
        wakeUp.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def instanceId: InstanceId
    def wakeUp: Optional[Boolean]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getWakeUp: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("wakeUp", wakeUp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotRequest
  ) extends zio.aws.ec2.model.GetConsoleScreenshotRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val wakeUp: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.wakeUp())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotRequest
  ): zio.aws.ec2.model.GetConsoleScreenshotRequest.ReadOnly = new Wrapper(impl)
}
