package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.CertificateId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAssociatedEnclaveCertificateIamRolesRequest(
    certificateArn: CertificateId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest = {
    import GetAssociatedEnclaveCertificateIamRolesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest
      .builder()
      .certificateArn(CertificateId.unwrap(certificateArn): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest.ReadOnly =
    zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest
      .wrap(buildAwsValue())
}
object GetAssociatedEnclaveCertificateIamRolesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest =
      zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest(
        certificateArn,
        dryRun.map(value => value)
      )
    def certificateArn: CertificateId
    def dryRun: Optional[Boolean]
    def getCertificateArn: ZIO[Any, Nothing, CertificateId] =
      ZIO.succeed(certificateArn)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest
  ) extends zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest.ReadOnly {
    override val certificateArn: CertificateId =
      zio.aws.ec2.model.primitives.CertificateId(impl.certificateArn())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest
  ): zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest.ReadOnly =
    new Wrapper(impl)
}
