package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait GatewayAssociationState {
  def unwrap: software.amazon.awssdk.services.ec2.model.GatewayAssociationState
}
object GatewayAssociationState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.GatewayAssociationState
  ): zio.aws.ec2.model.GatewayAssociationState = value match {
    case software.amazon.awssdk.services.ec2.model.GatewayAssociationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.GatewayAssociationState.ASSOCIATED =>
      val r = associated
      r
    case software.amazon.awssdk.services.ec2.model.GatewayAssociationState.NOT_ASSOCIATED =>
      val r = `not-associated`
      r
    case software.amazon.awssdk.services.ec2.model.GatewayAssociationState.ASSOCIATING =>
      val r = associating
      r
    case software.amazon.awssdk.services.ec2.model.GatewayAssociationState.DISASSOCIATING =>
      val r = disassociating
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.GatewayAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.GatewayAssociationState =
      software.amazon.awssdk.services.ec2.model.GatewayAssociationState.UNKNOWN_TO_SDK_VERSION
  }
  case object associated extends zio.aws.ec2.model.GatewayAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.GatewayAssociationState =
      software.amazon.awssdk.services.ec2.model.GatewayAssociationState.ASSOCIATED
  }
  case object `not-associated`
      extends zio.aws.ec2.model.GatewayAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.GatewayAssociationState =
      software.amazon.awssdk.services.ec2.model.GatewayAssociationState.NOT_ASSOCIATED
  }
  case object associating extends zio.aws.ec2.model.GatewayAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.GatewayAssociationState =
      software.amazon.awssdk.services.ec2.model.GatewayAssociationState.ASSOCIATING
  }
  case object disassociating extends zio.aws.ec2.model.GatewayAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.GatewayAssociationState =
      software.amazon.awssdk.services.ec2.model.GatewayAssociationState.DISASSOCIATING
  }
}
