package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait FleetStateCode {
  def unwrap: software.amazon.awssdk.services.ec2.model.FleetStateCode
}
object FleetStateCode {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.FleetStateCode
  ): zio.aws.ec2.model.FleetStateCode = value match {
    case software.amazon.awssdk.services.ec2.model.FleetStateCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.FleetStateCode.SUBMITTED =>
      val r = submitted
      r
    case software.amazon.awssdk.services.ec2.model.FleetStateCode.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.ec2.model.FleetStateCode.DELETED =>
      val r = deleted
      r
    case software.amazon.awssdk.services.ec2.model.FleetStateCode.FAILED =>
      val r = failed
      r
    case software.amazon.awssdk.services.ec2.model.FleetStateCode.DELETED_RUNNING =>
      val r = deleted_running
      r
    case software.amazon.awssdk.services.ec2.model.FleetStateCode.DELETED_TERMINATING =>
      val r = deleted_terminating
      r
    case software.amazon.awssdk.services.ec2.model.FleetStateCode.MODIFYING =>
      val r = modifying
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.FleetStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetStateCode =
      software.amazon.awssdk.services.ec2.model.FleetStateCode.UNKNOWN_TO_SDK_VERSION
  }
  case object submitted extends zio.aws.ec2.model.FleetStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetStateCode =
      software.amazon.awssdk.services.ec2.model.FleetStateCode.SUBMITTED
  }
  case object active extends zio.aws.ec2.model.FleetStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetStateCode =
      software.amazon.awssdk.services.ec2.model.FleetStateCode.ACTIVE
  }
  case object deleted extends zio.aws.ec2.model.FleetStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetStateCode =
      software.amazon.awssdk.services.ec2.model.FleetStateCode.DELETED
  }
  case object failed extends zio.aws.ec2.model.FleetStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetStateCode =
      software.amazon.awssdk.services.ec2.model.FleetStateCode.FAILED
  }
  case object deleted_running extends zio.aws.ec2.model.FleetStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetStateCode =
      software.amazon.awssdk.services.ec2.model.FleetStateCode.DELETED_RUNNING
  }
  case object deleted_terminating extends zio.aws.ec2.model.FleetStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetStateCode =
      software.amazon.awssdk.services.ec2.model.FleetStateCode.DELETED_TERMINATING
  }
  case object modifying extends zio.aws.ec2.model.FleetStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetStateCode =
      software.amazon.awssdk.services.ec2.model.FleetStateCode.MODIFYING
  }
}
