package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnableSerialConsoleAccessRequest(
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableSerialConsoleAccessRequest = {
    import EnableSerialConsoleAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableSerialConsoleAccessRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EnableSerialConsoleAccessRequest.ReadOnly =
    zio.aws.ec2.model.EnableSerialConsoleAccessRequest.wrap(buildAwsValue())
}
object EnableSerialConsoleAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableSerialConsoleAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnableSerialConsoleAccessRequest =
      zio.aws.ec2.model
        .EnableSerialConsoleAccessRequest(dryRun.map(value => value))
    def dryRun: Optional[Boolean]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableSerialConsoleAccessRequest
  ) extends zio.aws.ec2.model.EnableSerialConsoleAccessRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableSerialConsoleAccessRequest
  ): zio.aws.ec2.model.EnableSerialConsoleAccessRequest.ReadOnly = new Wrapper(
    impl
  )
}
