package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnableIpamOrganizationAdminAccountRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    delegatedAdminAccountId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableIpamOrganizationAdminAccountRequest = {
    import EnableIpamOrganizationAdminAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableIpamOrganizationAdminAccountRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .delegatedAdminAccountId(delegatedAdminAccountId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.EnableIpamOrganizationAdminAccountRequest.ReadOnly =
    zio.aws.ec2.model.EnableIpamOrganizationAdminAccountRequest
      .wrap(buildAwsValue())
}
object EnableIpamOrganizationAdminAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableIpamOrganizationAdminAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.EnableIpamOrganizationAdminAccountRequest =
      zio.aws.ec2.model.EnableIpamOrganizationAdminAccountRequest(
        dryRun.map(value => value),
        delegatedAdminAccountId
      )
    def dryRun: Optional[Boolean]
    def delegatedAdminAccountId: String
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getDelegatedAdminAccountId: ZIO[Any, Nothing, String] =
      ZIO.succeed(delegatedAdminAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableIpamOrganizationAdminAccountRequest
  ) extends zio.aws.ec2.model.EnableIpamOrganizationAdminAccountRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val delegatedAdminAccountId: String =
      impl.delegatedAdminAccountId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableIpamOrganizationAdminAccountRequest
  ): zio.aws.ec2.model.EnableIpamOrganizationAdminAccountRequest.ReadOnly =
    new Wrapper(impl)
}
