package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SnapshotId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnableFastSnapshotRestoresRequest(
    availabilityZones: Iterable[String],
    sourceSnapshotIds: Iterable[SnapshotId],
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresRequest = {
    import EnableFastSnapshotRestoresRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresRequest
      .builder()
      .availabilityZones(availabilityZones.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .sourceSnapshotIds(sourceSnapshotIds.map { item =>
        SnapshotId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EnableFastSnapshotRestoresRequest.ReadOnly =
    zio.aws.ec2.model.EnableFastSnapshotRestoresRequest.wrap(buildAwsValue())
}
object EnableFastSnapshotRestoresRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnableFastSnapshotRestoresRequest =
      zio.aws.ec2.model.EnableFastSnapshotRestoresRequest(
        availabilityZones,
        sourceSnapshotIds,
        dryRun.map(value => value)
      )
    def availabilityZones: List[String]
    def sourceSnapshotIds: List[SnapshotId]
    def dryRun: Optional[Boolean]
    def getAvailabilityZones: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(availabilityZones)
    def getSourceSnapshotIds: ZIO[Any, Nothing, List[SnapshotId]] =
      ZIO.succeed(sourceSnapshotIds)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresRequest
  ) extends zio.aws.ec2.model.EnableFastSnapshotRestoresRequest.ReadOnly {
    override val availabilityZones: List[String] = impl
      .availabilityZones()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val sourceSnapshotIds: List[SnapshotId] = impl
      .sourceSnapshotIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.SnapshotId(item)
      }
      .toList
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresRequest
  ): zio.aws.ec2.model.EnableFastSnapshotRestoresRequest.ReadOnly = new Wrapper(
    impl
  )
}
