package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.ElasticInferenceAcceleratorCount
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ElasticInferenceAccelerator(
    `type`: String,
    count: Optional[ElasticInferenceAcceleratorCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ElasticInferenceAccelerator = {
    import ElasticInferenceAccelerator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ElasticInferenceAccelerator
      .builder()
      .`type`(`type`: java.lang.String)
      .optionallyWith(
        count.map(value =>
          ElasticInferenceAcceleratorCount.unwrap(value): Integer
        )
      )(_.count)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ElasticInferenceAccelerator.ReadOnly =
    zio.aws.ec2.model.ElasticInferenceAccelerator.wrap(buildAwsValue())
}
object ElasticInferenceAccelerator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ElasticInferenceAccelerator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ElasticInferenceAccelerator =
      zio.aws.ec2.model
        .ElasticInferenceAccelerator(`type`, count.map(value => value))
    def `type`: String
    def count: Optional[ElasticInferenceAcceleratorCount]
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
    def getCount: ZIO[Any, AwsError, ElasticInferenceAcceleratorCount] =
      AwsError.unwrapOptionField("count", count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ElasticInferenceAccelerator
  ) extends zio.aws.ec2.model.ElasticInferenceAccelerator.ReadOnly {
    override val `type`: String = impl.`type`(): String
    override val count: Optional[ElasticInferenceAcceleratorCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.count())
        .map(value =>
          zio.aws.ec2.model.primitives.ElasticInferenceAcceleratorCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ElasticInferenceAccelerator
  ): zio.aws.ec2.model.ElasticInferenceAccelerator.ReadOnly = new Wrapper(impl)
}
