package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.EgressOnlyInternetGatewayId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EgressOnlyInternetGateway(
    attachments: Optional[
      Iterable[zio.aws.ec2.model.InternetGatewayAttachment]
    ] = Optional.Absent,
    egressOnlyInternetGatewayId: Optional[EgressOnlyInternetGatewayId] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EgressOnlyInternetGateway = {
    import EgressOnlyInternetGateway.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EgressOnlyInternetGateway
      .builder()
      .optionallyWith(
        attachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachments)
      .optionallyWith(
        egressOnlyInternetGatewayId.map(value =>
          EgressOnlyInternetGatewayId.unwrap(value): java.lang.String
        )
      )(_.egressOnlyInternetGatewayId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EgressOnlyInternetGateway.ReadOnly =
    zio.aws.ec2.model.EgressOnlyInternetGateway.wrap(buildAwsValue())
}
object EgressOnlyInternetGateway {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EgressOnlyInternetGateway
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EgressOnlyInternetGateway =
      zio.aws.ec2.model.EgressOnlyInternetGateway(
        attachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        egressOnlyInternetGatewayId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def attachments
        : Optional[List[zio.aws.ec2.model.InternetGatewayAttachment.ReadOnly]]
    def egressOnlyInternetGatewayId: Optional[EgressOnlyInternetGatewayId]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getAttachments: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InternetGatewayAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField("attachments", attachments)
    def getEgressOnlyInternetGatewayId
        : ZIO[Any, AwsError, EgressOnlyInternetGatewayId] =
      AwsError.unwrapOptionField(
        "egressOnlyInternetGatewayId",
        egressOnlyInternetGatewayId
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EgressOnlyInternetGateway
  ) extends zio.aws.ec2.model.EgressOnlyInternetGateway.ReadOnly {
    override val attachments
        : Optional[List[zio.aws.ec2.model.InternetGatewayAttachment.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InternetGatewayAttachment.wrap(item)
          }.toList
        )
    override val egressOnlyInternetGatewayId
        : Optional[EgressOnlyInternetGatewayId] = zio.aws.core.internal
      .optionalFromNullable(impl.egressOnlyInternetGatewayId())
      .map(value =>
        zio.aws.ec2.model.primitives.EgressOnlyInternetGatewayId(value)
      )
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EgressOnlyInternetGateway
  ): zio.aws.ec2.model.EgressOnlyInternetGateway.ReadOnly = new Wrapper(impl)
}
