package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  ClientVpnAssociationId,
  ClientVpnEndpointId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateClientVpnTargetNetworkRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    associationId: ClientVpnAssociationId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkRequest = {
    import DisassociateClientVpnTargetNetworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .associationId(
        ClientVpnAssociationId.unwrap(associationId): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateClientVpnTargetNetworkRequest.ReadOnly =
    zio.aws.ec2.model.DisassociateClientVpnTargetNetworkRequest
      .wrap(buildAwsValue())
}
object DisassociateClientVpnTargetNetworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DisassociateClientVpnTargetNetworkRequest =
      zio.aws.ec2.model.DisassociateClientVpnTargetNetworkRequest(
        clientVpnEndpointId,
        associationId,
        dryRun.map(value => value)
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def associationId: ClientVpnAssociationId
    def dryRun: Optional[Boolean]
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getAssociationId: ZIO[Any, Nothing, ClientVpnAssociationId] =
      ZIO.succeed(associationId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkRequest
  ) extends zio.aws.ec2.model.DisassociateClientVpnTargetNetworkRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val associationId: ClientVpnAssociationId =
      zio.aws.ec2.model.primitives.ClientVpnAssociationId(impl.associationId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkRequest
  ): zio.aws.ec2.model.DisassociateClientVpnTargetNetworkRequest.ReadOnly =
    new Wrapper(impl)
}
