package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  EipAllocationPublicIp,
  ElasticIpAssociationId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateAddressRequest(
    associationId: Optional[ElasticIpAssociationId] = Optional.Absent,
    publicIp: Optional[EipAllocationPublicIp] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateAddressRequest = {
    import DisassociateAddressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateAddressRequest
      .builder()
      .optionallyWith(
        associationId.map(value =>
          ElasticIpAssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        publicIp.map(value =>
          EipAllocationPublicIp.unwrap(value): java.lang.String
        )
      )(_.publicIp)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DisassociateAddressRequest.ReadOnly =
    zio.aws.ec2.model.DisassociateAddressRequest.wrap(buildAwsValue())
}
object DisassociateAddressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateAddressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisassociateAddressRequest =
      zio.aws.ec2.model.DisassociateAddressRequest(
        associationId.map(value => value),
        publicIp.map(value => value),
        dryRun.map(value => value)
      )
    def associationId: Optional[ElasticIpAssociationId]
    def publicIp: Optional[EipAllocationPublicIp]
    def dryRun: Optional[Boolean]
    def getAssociationId: ZIO[Any, AwsError, ElasticIpAssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getPublicIp: ZIO[Any, AwsError, EipAllocationPublicIp] =
      AwsError.unwrapOptionField("publicIp", publicIp)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateAddressRequest
  ) extends zio.aws.ec2.model.DisassociateAddressRequest.ReadOnly {
    override val associationId: Optional[ElasticIpAssociationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationId())
        .map(value =>
          zio.aws.ec2.model.primitives.ElasticIpAssociationId(value)
        )
    override val publicIp: Optional[EipAllocationPublicIp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicIp())
        .map(value => zio.aws.ec2.model.primitives.EipAllocationPublicIp(value))
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateAddressRequest
  ): zio.aws.ec2.model.DisassociateAddressRequest.ReadOnly = new Wrapper(impl)
}
