package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisableFastSnapshotRestoreErrorItem(
    snapshotId: Optional[String] = Optional.Absent,
    fastSnapshotRestoreStateErrors: Optional[
      Iterable[zio.aws.ec2.model.DisableFastSnapshotRestoreStateErrorItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreErrorItem = {
    import DisableFastSnapshotRestoreErrorItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreErrorItem
      .builder()
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .optionallyWith(
        fastSnapshotRestoreStateErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fastSnapshotRestoreStateErrors)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisableFastSnapshotRestoreErrorItem.ReadOnly =
    zio.aws.ec2.model.DisableFastSnapshotRestoreErrorItem.wrap(buildAwsValue())
}
object DisableFastSnapshotRestoreErrorItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreErrorItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisableFastSnapshotRestoreErrorItem =
      zio.aws.ec2.model.DisableFastSnapshotRestoreErrorItem(
        snapshotId.map(value => value),
        fastSnapshotRestoreStateErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def snapshotId: Optional[String]
    def fastSnapshotRestoreStateErrors: Optional[
      List[zio.aws.ec2.model.DisableFastSnapshotRestoreStateErrorItem.ReadOnly]
    ]
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getFastSnapshotRestoreStateErrors: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.DisableFastSnapshotRestoreStateErrorItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "fastSnapshotRestoreStateErrors",
      fastSnapshotRestoreStateErrors
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreErrorItem
  ) extends zio.aws.ec2.model.DisableFastSnapshotRestoreErrorItem.ReadOnly {
    override val snapshotId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => value: String)
    override val fastSnapshotRestoreStateErrors: Optional[
      List[zio.aws.ec2.model.DisableFastSnapshotRestoreStateErrorItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fastSnapshotRestoreStateErrors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.DisableFastSnapshotRestoreStateErrorItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreErrorItem
  ): zio.aws.ec2.model.DisableFastSnapshotRestoreErrorItem.ReadOnly =
    new Wrapper(impl)
}
