package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.AllocationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisableAddressTransferRequest(
    allocationId: AllocationId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableAddressTransferRequest = {
    import DisableAddressTransferRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableAddressTransferRequest
      .builder()
      .allocationId(AllocationId.unwrap(allocationId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DisableAddressTransferRequest.ReadOnly =
    zio.aws.ec2.model.DisableAddressTransferRequest.wrap(buildAwsValue())
}
object DisableAddressTransferRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableAddressTransferRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisableAddressTransferRequest =
      zio.aws.ec2.model
        .DisableAddressTransferRequest(allocationId, dryRun.map(value => value))
    def allocationId: AllocationId
    def dryRun: Optional[Boolean]
    def getAllocationId: ZIO[Any, Nothing, AllocationId] =
      ZIO.succeed(allocationId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableAddressTransferRequest
  ) extends zio.aws.ec2.model.DisableAddressTransferRequest.ReadOnly {
    override val allocationId: AllocationId =
      zio.aws.ec2.model.primitives.AllocationId(impl.allocationId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableAddressTransferRequest
  ): zio.aws.ec2.model.DisableAddressTransferRequest.ReadOnly = new Wrapper(
    impl
  )
}
