package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInterfaceAttachmentId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetachNetworkInterfaceRequest(
    attachmentId: NetworkInterfaceAttachmentId,
    dryRun: Optional[Boolean] = Optional.Absent,
    force: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DetachNetworkInterfaceRequest = {
    import DetachNetworkInterfaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DetachNetworkInterfaceRequest
      .builder()
      .attachmentId(
        NetworkInterfaceAttachmentId.unwrap(attachmentId): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DetachNetworkInterfaceRequest.ReadOnly =
    zio.aws.ec2.model.DetachNetworkInterfaceRequest.wrap(buildAwsValue())
}
object DetachNetworkInterfaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DetachNetworkInterfaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DetachNetworkInterfaceRequest =
      zio.aws.ec2.model.DetachNetworkInterfaceRequest(
        attachmentId,
        dryRun.map(value => value),
        force.map(value => value)
      )
    def attachmentId: NetworkInterfaceAttachmentId
    def dryRun: Optional[Boolean]
    def force: Optional[Boolean]
    def getAttachmentId: ZIO[Any, Nothing, NetworkInterfaceAttachmentId] =
      ZIO.succeed(attachmentId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getForce: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DetachNetworkInterfaceRequest
  ) extends zio.aws.ec2.model.DetachNetworkInterfaceRequest.ReadOnly {
    override val attachmentId: NetworkInterfaceAttachmentId =
      zio.aws.ec2.model.primitives
        .NetworkInterfaceAttachmentId(impl.attachmentId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val force: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.force())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DetachNetworkInterfaceRequest
  ): zio.aws.ec2.model.DetachNetworkInterfaceRequest.ReadOnly = new Wrapper(
    impl
  )
}
