package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpcId, InstanceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetachClassicLinkVpcRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    instanceId: InstanceId,
    vpcId: VpcId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcRequest = {
    import DetachClassicLinkVpcRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DetachClassicLinkVpcRequest.ReadOnly =
    zio.aws.ec2.model.DetachClassicLinkVpcRequest.wrap(buildAwsValue())
}
object DetachClassicLinkVpcRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DetachClassicLinkVpcRequest =
      zio.aws.ec2.model.DetachClassicLinkVpcRequest(
        dryRun.map(value => value),
        instanceId,
        vpcId
      )
    def dryRun: Optional[Boolean]
    def instanceId: InstanceId
    def vpcId: VpcId
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcRequest
  ) extends zio.aws.ec2.model.DetachClassicLinkVpcRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcRequest
  ): zio.aws.ec2.model.DetachClassicLinkVpcRequest.ReadOnly = new Wrapper(impl)
}
