package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, VpcEndpointServiceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVpcEndpointServicePermissionsRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    serviceId: VpcEndpointServiceId,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsRequest = {
    import DescribeVpcEndpointServicePermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .serviceId(VpcEndpointServiceId.unwrap(serviceId): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsRequest
      .wrap(buildAwsValue())
}
object DescribeVpcEndpointServicePermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsRequest =
      zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsRequest(
        dryRun.map(value => value),
        serviceId,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def serviceId: VpcEndpointServiceId
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getServiceId: ZIO[Any, Nothing, VpcEndpointServiceId] =
      ZIO.succeed(serviceId)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsRequest
  ) extends zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val serviceId: VpcEndpointServiceId =
      zio.aws.ec2.model.primitives.VpcEndpointServiceId(impl.serviceId())
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsRequest
  ): zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsRequest.ReadOnly =
    new Wrapper(impl)
}
