package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VolumeId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVolumeAttributeRequest(
    attribute: zio.aws.ec2.model.VolumeAttributeName,
    volumeId: VolumeId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeRequest = {
    import DescribeVolumeAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeRequest
      .builder()
      .attribute(attribute.unwrap)
      .volumeId(VolumeId.unwrap(volumeId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVolumeAttributeRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVolumeAttributeRequest.wrap(buildAwsValue())
}
object DescribeVolumeAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVolumeAttributeRequest =
      zio.aws.ec2.model.DescribeVolumeAttributeRequest(
        attribute,
        volumeId,
        dryRun.map(value => value)
      )
    def attribute: zio.aws.ec2.model.VolumeAttributeName
    def volumeId: VolumeId
    def dryRun: Optional[Boolean]
    def getAttribute: ZIO[Any, Nothing, zio.aws.ec2.model.VolumeAttributeName] =
      ZIO.succeed(attribute)
    def getVolumeId: ZIO[Any, Nothing, VolumeId] = ZIO.succeed(volumeId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeRequest
  ) extends zio.aws.ec2.model.DescribeVolumeAttributeRequest.ReadOnly {
    override val attribute: zio.aws.ec2.model.VolumeAttributeName =
      zio.aws.ec2.model.VolumeAttributeName.wrap(impl.attribute())
    override val volumeId: VolumeId =
      zio.aws.ec2.model.primitives.VolumeId(impl.volumeId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeRequest
  ): zio.aws.ec2.model.DescribeVolumeAttributeRequest.ReadOnly = new Wrapper(
    impl
  )
}
