package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVerifiedAccessEndpointsResponse(
    verifiedAccessEndpoints: Optional[
      Iterable[zio.aws.ec2.model.VerifiedAccessEndpoint]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessEndpointsResponse = {
    import DescribeVerifiedAccessEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessEndpointsResponse
      .builder()
      .optionallyWith(
        verifiedAccessEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.verifiedAccessEndpoints)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVerifiedAccessEndpointsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVerifiedAccessEndpointsResponse
      .wrap(buildAwsValue())
}
object DescribeVerifiedAccessEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVerifiedAccessEndpointsResponse =
      zio.aws.ec2.model.DescribeVerifiedAccessEndpointsResponse(
        verifiedAccessEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def verifiedAccessEndpoints
        : Optional[List[zio.aws.ec2.model.VerifiedAccessEndpoint.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getVerifiedAccessEndpoints: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VerifiedAccessEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "verifiedAccessEndpoints",
      verifiedAccessEndpoints
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessEndpointsResponse
  ) extends zio.aws.ec2.model.DescribeVerifiedAccessEndpointsResponse.ReadOnly {
    override val verifiedAccessEndpoints
        : Optional[List[zio.aws.ec2.model.VerifiedAccessEndpoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessEndpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.VerifiedAccessEndpoint.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessEndpointsResponse
  ): zio.aws.ec2.model.DescribeVerifiedAccessEndpointsResponse.ReadOnly =
    new Wrapper(impl)
}
