package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  SpotFleetRequestId,
  DescribeSpotFleetInstancesMaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeSpotFleetInstancesRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    maxResults: Optional[DescribeSpotFleetInstancesMaxResults] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    spotFleetRequestId: SpotFleetRequestId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesRequest = {
    import DescribeSpotFleetInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        maxResults.map(value =>
          DescribeSpotFleetInstancesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .spotFleetRequestId(
        SpotFleetRequestId.unwrap(spotFleetRequestId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeSpotFleetInstancesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeSpotFleetInstancesRequest.wrap(buildAwsValue())
}
object DescribeSpotFleetInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSpotFleetInstancesRequest =
      zio.aws.ec2.model.DescribeSpotFleetInstancesRequest(
        dryRun.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        spotFleetRequestId
      )
    def dryRun: Optional[Boolean]
    def maxResults: Optional[DescribeSpotFleetInstancesMaxResults]
    def nextToken: Optional[String]
    def spotFleetRequestId: SpotFleetRequestId
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeSpotFleetInstancesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSpotFleetRequestId: ZIO[Any, Nothing, SpotFleetRequestId] =
      ZIO.succeed(spotFleetRequestId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesRequest
  ) extends zio.aws.ec2.model.DescribeSpotFleetInstancesRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val maxResults: Optional[DescribeSpotFleetInstancesMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeSpotFleetInstancesMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val spotFleetRequestId: SpotFleetRequestId =
      zio.aws.ec2.model.primitives.SpotFleetRequestId(impl.spotFleetRequestId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesRequest
  ): zio.aws.ec2.model.DescribeSpotFleetInstancesRequest.ReadOnly = new Wrapper(
    impl
  )
}
