package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  Integer,
  DescribeScheduledInstanceAvailabilityMaxResults
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeScheduledInstanceAvailabilityRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    firstSlotStartTimeRange: zio.aws.ec2.model.SlotDateTimeRangeRequest,
    maxResults: Optional[DescribeScheduledInstanceAvailabilityMaxResults] =
      Optional.Absent,
    maxSlotDurationInHours: Optional[Integer] = Optional.Absent,
    minSlotDurationInHours: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    recurrence: zio.aws.ec2.model.ScheduledInstanceRecurrenceRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest = {
    import DescribeScheduledInstanceAvailabilityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .firstSlotStartTimeRange(firstSlotStartTimeRange.buildAwsValue())
      .optionallyWith(
        maxResults.map(value =>
          DescribeScheduledInstanceAvailabilityMaxResults.unwrap(
            value
          ): java.lang.Integer
        )
      )(_.maxResults)
      .optionallyWith(
        maxSlotDurationInHours.map(value => value: java.lang.Integer)
      )(_.maxSlotDurationInHours)
      .optionallyWith(
        minSlotDurationInHours.map(value => value: java.lang.Integer)
      )(_.minSlotDurationInHours)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .recurrence(recurrence.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityRequest.ReadOnly =
    zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityRequest
      .wrap(buildAwsValue())
}
object DescribeScheduledInstanceAvailabilityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityRequest =
      zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityRequest(
        dryRun.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        firstSlotStartTimeRange.asEditable,
        maxResults.map(value => value),
        maxSlotDurationInHours.map(value => value),
        minSlotDurationInHours.map(value => value),
        nextToken.map(value => value),
        recurrence.asEditable
      )
    def dryRun: Optional[Boolean]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def firstSlotStartTimeRange
        : zio.aws.ec2.model.SlotDateTimeRangeRequest.ReadOnly
    def maxResults: Optional[DescribeScheduledInstanceAvailabilityMaxResults]
    def maxSlotDurationInHours: Optional[Integer]
    def minSlotDurationInHours: Optional[Integer]
    def nextToken: Optional[String]
    def recurrence
        : zio.aws.ec2.model.ScheduledInstanceRecurrenceRequest.ReadOnly
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getFirstSlotStartTimeRange: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.SlotDateTimeRangeRequest.ReadOnly
    ] = ZIO.succeed(firstSlotStartTimeRange)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeScheduledInstanceAvailabilityMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getMaxSlotDurationInHours: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("maxSlotDurationInHours", maxSlotDurationInHours)
    def getMinSlotDurationInHours: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("minSlotDurationInHours", minSlotDurationInHours)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRecurrence: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.ScheduledInstanceRecurrenceRequest.ReadOnly
    ] = ZIO.succeed(recurrence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest
  ) extends zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val firstSlotStartTimeRange
        : zio.aws.ec2.model.SlotDateTimeRangeRequest.ReadOnly =
      zio.aws.ec2.model.SlotDateTimeRangeRequest
        .wrap(impl.firstSlotStartTimeRange())
    override val maxResults
        : Optional[DescribeScheduledInstanceAvailabilityMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeScheduledInstanceAvailabilityMaxResults(value)
        )
    override val maxSlotDurationInHours: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxSlotDurationInHours())
        .map(value => value: Integer)
    override val minSlotDurationInHours: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minSlotDurationInHours())
        .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val recurrence
        : zio.aws.ec2.model.ScheduledInstanceRecurrenceRequest.ReadOnly =
      zio.aws.ec2.model.ScheduledInstanceRecurrenceRequest
        .wrap(impl.recurrence())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest
  ): zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityRequest.ReadOnly =
    new Wrapper(impl)
}
