package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{IpamMaxResults, NextToken}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeIpamResourceDiscoveryAssociationsRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    ipamResourceDiscoveryAssociationIds: Optional[Iterable[String]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[IpamMaxResults] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveryAssociationsRequest = {
    import DescribeIpamResourceDiscoveryAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveryAssociationsRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        ipamResourceDiscoveryAssociationIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ipamResourceDiscoveryAssociationIds)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => IpamMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeIpamResourceDiscoveryAssociationsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeIpamResourceDiscoveryAssociationsRequest
      .wrap(buildAwsValue())
}
object DescribeIpamResourceDiscoveryAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveryAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeIpamResourceDiscoveryAssociationsRequest =
      zio.aws.ec2.model.DescribeIpamResourceDiscoveryAssociationsRequest(
        dryRun.map(value => value),
        ipamResourceDiscoveryAssociationIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dryRun: Optional[Boolean]
    def ipamResourceDiscoveryAssociationIds: Optional[List[String]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[IpamMaxResults]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getIpamResourceDiscoveryAssociationIds
        : ZIO[Any, AwsError, List[String]] = AwsError.unwrapOptionField(
      "ipamResourceDiscoveryAssociationIds",
      ipamResourceDiscoveryAssociationIds
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, IpamMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveryAssociationsRequest
  ) extends zio.aws.ec2.model.DescribeIpamResourceDiscoveryAssociationsRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val ipamResourceDiscoveryAssociationIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamResourceDiscoveryAssociationIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val maxResults: Optional[IpamMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.IpamMaxResults(value))
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveryAssociationsRequest
  ): zio.aws.ec2.model.DescribeIpamResourceDiscoveryAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
