package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, InstanceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeInstanceStatusRequest(
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    instanceIds: Optional[Iterable[InstanceId]] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    includeAllInstances: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest = {
    import DescribeInstanceStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        instanceIds.map(value =>
          value.map { item =>
            InstanceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceIds)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        includeAllInstances.map(value => value: java.lang.Boolean)
      )(_.includeAllInstances)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeInstanceStatusRequest.ReadOnly =
    zio.aws.ec2.model.DescribeInstanceStatusRequest.wrap(buildAwsValue())
}
object DescribeInstanceStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeInstanceStatusRequest =
      zio.aws.ec2.model.DescribeInstanceStatusRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        dryRun.map(value => value),
        includeAllInstances.map(value => value)
      )
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def instanceIds: Optional[List[InstanceId]]
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def dryRun: Optional[Boolean]
    def includeAllInstances: Optional[Boolean]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getInstanceIds: ZIO[Any, AwsError, List[InstanceId]] =
      AwsError.unwrapOptionField("instanceIds", instanceIds)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getIncludeAllInstances: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeAllInstances", includeAllInstances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest
  ) extends zio.aws.ec2.model.DescribeInstanceStatusRequest.ReadOnly {
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val instanceIds: Optional[List[InstanceId]] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.InstanceId(item)
        }.toList
      )
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val includeAllInstances: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeAllInstances())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest
  ): zio.aws.ec2.model.DescribeInstanceStatusRequest.ReadOnly = new Wrapper(
    impl
  )
}
