package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeInstanceConnectEndpointsResponse(
    instanceConnectEndpoints: Optional[
      Iterable[zio.aws.ec2.model.Ec2InstanceConnectEndpoint]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInstanceConnectEndpointsResponse = {
    import DescribeInstanceConnectEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInstanceConnectEndpointsResponse
      .builder()
      .optionallyWith(
        instanceConnectEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceConnectEndpoints)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeInstanceConnectEndpointsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeInstanceConnectEndpointsResponse
      .wrap(buildAwsValue())
}
object DescribeInstanceConnectEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInstanceConnectEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeInstanceConnectEndpointsResponse =
      zio.aws.ec2.model.DescribeInstanceConnectEndpointsResponse(
        instanceConnectEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def instanceConnectEndpoints
        : Optional[List[zio.aws.ec2.model.Ec2InstanceConnectEndpoint.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getInstanceConnectEndpoints: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Ec2InstanceConnectEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "instanceConnectEndpoints",
      instanceConnectEndpoints
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceConnectEndpointsResponse
  ) extends zio.aws.ec2.model.DescribeInstanceConnectEndpointsResponse.ReadOnly {
    override val instanceConnectEndpoints: Optional[
      List[zio.aws.ec2.model.Ec2InstanceConnectEndpoint.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceConnectEndpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Ec2InstanceConnectEndpoint.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceConnectEndpointsResponse
  ): zio.aws.ec2.model.DescribeInstanceConnectEndpointsResponse.ReadOnly =
    new Wrapper(impl)
}
