package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeImageAttributeResponse(
    blockDeviceMappings: Optional[
      Iterable[zio.aws.ec2.model.BlockDeviceMapping]
    ] = Optional.Absent,
    imageId: Optional[String] = Optional.Absent,
    launchPermissions: Optional[Iterable[zio.aws.ec2.model.LaunchPermission]] =
      Optional.Absent,
    productCodes: Optional[Iterable[zio.aws.ec2.model.ProductCode]] =
      Optional.Absent,
    description: Optional[zio.aws.ec2.model.AttributeValue] = Optional.Absent,
    kernelId: Optional[zio.aws.ec2.model.AttributeValue] = Optional.Absent,
    ramdiskId: Optional[zio.aws.ec2.model.AttributeValue] = Optional.Absent,
    sriovNetSupport: Optional[zio.aws.ec2.model.AttributeValue] =
      Optional.Absent,
    bootMode: Optional[zio.aws.ec2.model.AttributeValue] = Optional.Absent,
    tpmSupport: Optional[zio.aws.ec2.model.AttributeValue] = Optional.Absent,
    uefiData: Optional[zio.aws.ec2.model.AttributeValue] = Optional.Absent,
    lastLaunchedTime: Optional[zio.aws.ec2.model.AttributeValue] =
      Optional.Absent,
    imdsSupport: Optional[zio.aws.ec2.model.AttributeValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeImageAttributeResponse = {
    import DescribeImageAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeImageAttributeResponse
      .builder()
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .optionallyWith(
        launchPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launchPermissions)
      .optionallyWith(
        productCodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productCodes)
      .optionallyWith(description.map(value => value.buildAwsValue()))(
        _.description
      )
      .optionallyWith(kernelId.map(value => value.buildAwsValue()))(_.kernelId)
      .optionallyWith(ramdiskId.map(value => value.buildAwsValue()))(
        _.ramdiskId
      )
      .optionallyWith(sriovNetSupport.map(value => value.buildAwsValue()))(
        _.sriovNetSupport
      )
      .optionallyWith(bootMode.map(value => value.buildAwsValue()))(_.bootMode)
      .optionallyWith(tpmSupport.map(value => value.buildAwsValue()))(
        _.tpmSupport
      )
      .optionallyWith(uefiData.map(value => value.buildAwsValue()))(_.uefiData)
      .optionallyWith(lastLaunchedTime.map(value => value.buildAwsValue()))(
        _.lastLaunchedTime
      )
      .optionallyWith(imdsSupport.map(value => value.buildAwsValue()))(
        _.imdsSupport
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeImageAttributeResponse.ReadOnly =
    zio.aws.ec2.model.DescribeImageAttributeResponse.wrap(buildAwsValue())
}
object DescribeImageAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeImageAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeImageAttributeResponse =
      zio.aws.ec2.model.DescribeImageAttributeResponse(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        imageId.map(value => value),
        launchPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        productCodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        description.map(value => value.asEditable),
        kernelId.map(value => value.asEditable),
        ramdiskId.map(value => value.asEditable),
        sriovNetSupport.map(value => value.asEditable),
        bootMode.map(value => value.asEditable),
        tpmSupport.map(value => value.asEditable),
        uefiData.map(value => value.asEditable),
        lastLaunchedTime.map(value => value.asEditable),
        imdsSupport.map(value => value.asEditable)
      )
    def blockDeviceMappings
        : Optional[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]]
    def imageId: Optional[String]
    def launchPermissions
        : Optional[List[zio.aws.ec2.model.LaunchPermission.ReadOnly]]
    def productCodes: Optional[List[zio.aws.ec2.model.ProductCode.ReadOnly]]
    def description: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def kernelId: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def ramdiskId: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def sriovNetSupport: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def bootMode: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def tpmSupport: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def uefiData: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def lastLaunchedTime: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def imdsSupport: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.BlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getLaunchPermissions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchPermission.ReadOnly
    ]] = AwsError.unwrapOptionField("launchPermissions", launchPermissions)
    def getProductCodes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ProductCode.ReadOnly]] =
      AwsError.unwrapOptionField("productCodes", productCodes)
    def getDescription
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("description", description)
    def getKernelId
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getRamdiskId
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("ramdiskId", ramdiskId)
    def getSriovNetSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("sriovNetSupport", sriovNetSupport)
    def getBootMode
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("bootMode", bootMode)
    def getTpmSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("tpmSupport", tpmSupport)
    def getUefiData
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("uefiData", uefiData)
    def getLastLaunchedTime
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("lastLaunchedTime", lastLaunchedTime)
    def getImdsSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("imdsSupport", imdsSupport)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImageAttributeResponse
  ) extends zio.aws.ec2.model.DescribeImageAttributeResponse.ReadOnly {
    override val blockDeviceMappings
        : Optional[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockDeviceMappings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.BlockDeviceMapping.wrap(item)
          }.toList
        )
    override val imageId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => value: String)
    override val launchPermissions
        : Optional[List[zio.aws.ec2.model.LaunchPermission.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchPermissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.LaunchPermission.wrap(item)
          }.toList
        )
    override val productCodes
        : Optional[List[zio.aws.ec2.model.ProductCode.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productCodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ProductCode.wrap(item)
          }.toList
        )
    override val description
        : Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val kernelId: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kernelId())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val ramdiskId
        : Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ramdiskId())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val sriovNetSupport
        : Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sriovNetSupport())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val bootMode: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bootMode())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val tpmSupport
        : Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tpmSupport())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val uefiData: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uefiData())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val lastLaunchedTime
        : Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastLaunchedTime())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val imdsSupport
        : Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imdsSupport())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImageAttributeResponse
  ): zio.aws.ec2.model.DescribeImageAttributeResponse.ReadOnly = new Wrapper(
    impl
  )
}
