package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{DateTime, FleetId, Integer}
import scala.jdk.CollectionConverters._
final case class DescribeFleetHistoryRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    eventType: Optional[zio.aws.ec2.model.FleetEventType] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    fleetId: FleetId,
    startTime: DateTime
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryRequest = {
    import DescribeFleetHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(eventType.map(value => value.unwrap))(_.eventType)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .startTime(DateTime.unwrap(startTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeFleetHistoryRequest.ReadOnly =
    zio.aws.ec2.model.DescribeFleetHistoryRequest.wrap(buildAwsValue())
}
object DescribeFleetHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeFleetHistoryRequest =
      zio.aws.ec2.model.DescribeFleetHistoryRequest(
        dryRun.map(value => value),
        eventType.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        fleetId,
        startTime
      )
    def dryRun: Optional[Boolean]
    def eventType: Optional[zio.aws.ec2.model.FleetEventType]
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def fleetId: FleetId
    def startTime: DateTime
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getEventType: ZIO[Any, AwsError, zio.aws.ec2.model.FleetEventType] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getStartTime: ZIO[Any, Nothing, DateTime] = ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryRequest
  ) extends zio.aws.ec2.model.DescribeFleetHistoryRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val eventType: Optional[zio.aws.ec2.model.FleetEventType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventType())
        .map(value => zio.aws.ec2.model.FleetEventType.wrap(value))
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val fleetId: FleetId =
      zio.aws.ec2.model.primitives.FleetId(impl.fleetId())
    override val startTime: DateTime =
      zio.aws.ec2.model.primitives.DateTime(impl.startTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryRequest
  ): zio.aws.ec2.model.DescribeFleetHistoryRequest.ReadOnly = new Wrapper(impl)
}
