package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  DescribeExportImageTasksMaxResults,
  ExportImageTaskId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeExportImageTasksRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    exportImageTaskIds: Optional[Iterable[ExportImageTaskId]] = Optional.Absent,
    maxResults: Optional[DescribeExportImageTasksMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksRequest = {
    import DescribeExportImageTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        exportImageTaskIds.map(value =>
          value.map { item =>
            ExportImageTaskId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.exportImageTaskIds)
      .optionallyWith(
        maxResults.map(value =>
          DescribeExportImageTasksMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeExportImageTasksRequest.ReadOnly =
    zio.aws.ec2.model.DescribeExportImageTasksRequest.wrap(buildAwsValue())
}
object DescribeExportImageTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeExportImageTasksRequest =
      zio.aws.ec2.model.DescribeExportImageTasksRequest(
        dryRun.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        exportImageTaskIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def exportImageTaskIds: Optional[List[ExportImageTaskId]]
    def maxResults: Optional[DescribeExportImageTasksMaxResults]
    def nextToken: Optional[NextToken]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getExportImageTaskIds: ZIO[Any, AwsError, List[ExportImageTaskId]] =
      AwsError.unwrapOptionField("exportImageTaskIds", exportImageTaskIds)
    def getMaxResults: ZIO[Any, AwsError, DescribeExportImageTasksMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksRequest
  ) extends zio.aws.ec2.model.DescribeExportImageTasksRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val exportImageTaskIds: Optional[List[ExportImageTaskId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportImageTaskIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.ExportImageTaskId(item)
          }.toList
        )
    override val maxResults: Optional[DescribeExportImageTasksMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.DescribeExportImageTasksMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksRequest
  ): zio.aws.ec2.model.DescribeExportImageTasksRequest.ReadOnly = new Wrapper(
    impl
  )
}
