package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{NextToken, DescribeByoipCidrsMaxResults}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeByoipCidrsRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    maxResults: DescribeByoipCidrsMaxResults,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsRequest = {
    import DescribeByoipCidrsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .maxResults(DescribeByoipCidrsMaxResults.unwrap(maxResults): Integer)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeByoipCidrsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeByoipCidrsRequest.wrap(buildAwsValue())
}
object DescribeByoipCidrsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeByoipCidrsRequest =
      zio.aws.ec2.model.DescribeByoipCidrsRequest(
        dryRun.map(value => value),
        maxResults,
        nextToken.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def maxResults: DescribeByoipCidrsMaxResults
    def nextToken: Optional[NextToken]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getMaxResults: ZIO[Any, Nothing, DescribeByoipCidrsMaxResults] =
      ZIO.succeed(maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsRequest
  ) extends zio.aws.ec2.model.DescribeByoipCidrsRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val maxResults: DescribeByoipCidrsMaxResults =
      zio.aws.ec2.model.primitives
        .DescribeByoipCidrsMaxResults(impl.maxResults())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsRequest
  ): zio.aws.ec2.model.DescribeByoipCidrsRequest.ReadOnly = new Wrapper(impl)
}
