package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.MaxResultsParam
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeAwsNetworkPerformanceMetricSubscriptionsRequest(
    maxResults: Optional[MaxResultsParam] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsRequest = {
    import DescribeAwsNetworkPerformanceMetricSubscriptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResultsParam.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsRequest
      .wrap(buildAwsValue())
}
object DescribeAwsNetworkPerformanceMetricSubscriptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsRequest =
      zio.aws.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value)
      )
    def maxResults: Optional[MaxResultsParam]
    def nextToken: Optional[String]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def dryRun: Optional[Boolean]
    def getMaxResults: ZIO[Any, AwsError, MaxResultsParam] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsRequest
  ) extends zio.aws.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsRequest.ReadOnly {
    override val maxResults: Optional[MaxResultsParam] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.MaxResultsParam(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsRequest
  ): zio.aws.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsRequest.ReadOnly =
    new Wrapper(impl)
}
