package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  NetworkInterfaceId,
  TransitGatewayMulticastDomainId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeregisterTransitGatewayMulticastGroupSourcesRequest(
    transitGatewayMulticastDomainId: Optional[TransitGatewayMulticastDomainId] =
      Optional.Absent,
    groupIpAddress: Optional[String] = Optional.Absent,
    networkInterfaceIds: Optional[Iterable[NetworkInterfaceId]] =
      Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest = {
    import DeregisterTransitGatewayMulticastGroupSourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest
      .builder()
      .optionallyWith(
        transitGatewayMulticastDomainId.map(value =>
          TransitGatewayMulticastDomainId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayMulticastDomainId)
      .optionallyWith(groupIpAddress.map(value => value: java.lang.String))(
        _.groupIpAddress
      )
      .optionallyWith(
        networkInterfaceIds.map(value =>
          value.map { item =>
            NetworkInterfaceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.networkInterfaceIds)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest.ReadOnly =
    zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest
      .wrap(buildAwsValue())
}
object DeregisterTransitGatewayMulticastGroupSourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest =
      zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest(
        transitGatewayMulticastDomainId.map(value => value),
        groupIpAddress.map(value => value),
        networkInterfaceIds.map(value => value),
        dryRun.map(value => value)
      )
    def transitGatewayMulticastDomainId
        : Optional[TransitGatewayMulticastDomainId]
    def groupIpAddress: Optional[String]
    def networkInterfaceIds: Optional[List[NetworkInterfaceId]]
    def dryRun: Optional[Boolean]
    def getTransitGatewayMulticastDomainId
        : ZIO[Any, AwsError, TransitGatewayMulticastDomainId] =
      AwsError.unwrapOptionField(
        "transitGatewayMulticastDomainId",
        transitGatewayMulticastDomainId
      )
    def getGroupIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupIpAddress", groupIpAddress)
    def getNetworkInterfaceIds: ZIO[Any, AwsError, List[NetworkInterfaceId]] =
      AwsError.unwrapOptionField("networkInterfaceIds", networkInterfaceIds)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest
  ) extends zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest.ReadOnly {
    override val transitGatewayMulticastDomainId
        : Optional[TransitGatewayMulticastDomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayMulticastDomainId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayMulticastDomainId(value)
      )
    override val groupIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupIpAddress())
      .map(value => value: String)
    override val networkInterfaceIds: Optional[List[NetworkInterfaceId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.NetworkInterfaceId(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest
  ): zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest.ReadOnly =
    new Wrapper(impl)
}
