package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeprovisionByoipCidrRequest(
    cidr: String,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeprovisionByoipCidrRequest = {
    import DeprovisionByoipCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeprovisionByoipCidrRequest
      .builder()
      .cidr(cidr: java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeprovisionByoipCidrRequest.ReadOnly =
    zio.aws.ec2.model.DeprovisionByoipCidrRequest.wrap(buildAwsValue())
}
object DeprovisionByoipCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeprovisionByoipCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeprovisionByoipCidrRequest =
      zio.aws.ec2.model
        .DeprovisionByoipCidrRequest(cidr, dryRun.map(value => value))
    def cidr: String
    def dryRun: Optional[Boolean]
    def getCidr: ZIO[Any, Nothing, String] = ZIO.succeed(cidr)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeprovisionByoipCidrRequest
  ) extends zio.aws.ec2.model.DeprovisionByoipCidrRequest.ReadOnly {
    override val cidr: String = impl.cidr(): String
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeprovisionByoipCidrRequest
  ): zio.aws.ec2.model.DeprovisionByoipCidrRequest.ReadOnly = new Wrapper(impl)
}
