package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpnGatewayId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteVpnGatewayRequest(
    vpnGatewayId: VpnGatewayId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteVpnGatewayRequest = {
    import DeleteVpnGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteVpnGatewayRequest
      .builder()
      .vpnGatewayId(VpnGatewayId.unwrap(vpnGatewayId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteVpnGatewayRequest.ReadOnly =
    zio.aws.ec2.model.DeleteVpnGatewayRequest.wrap(buildAwsValue())
}
object DeleteVpnGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteVpnGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteVpnGatewayRequest =
      zio.aws.ec2.model
        .DeleteVpnGatewayRequest(vpnGatewayId, dryRun.map(value => value))
    def vpnGatewayId: VpnGatewayId
    def dryRun: Optional[Boolean]
    def getVpnGatewayId: ZIO[Any, Nothing, VpnGatewayId] =
      ZIO.succeed(vpnGatewayId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpnGatewayRequest
  ) extends zio.aws.ec2.model.DeleteVpnGatewayRequest.ReadOnly {
    override val vpnGatewayId: VpnGatewayId =
      zio.aws.ec2.model.primitives.VpnGatewayId(impl.vpnGatewayId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpnGatewayRequest
  ): zio.aws.ec2.model.DeleteVpnGatewayRequest.ReadOnly = new Wrapper(impl)
}
