package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcPeeringConnectionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteVpcPeeringConnectionRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    vpcPeeringConnectionId: VpcPeeringConnectionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionRequest = {
    import DeleteVpcPeeringConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .vpcPeeringConnectionId(
        VpcPeeringConnectionId.unwrap(vpcPeeringConnectionId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteVpcPeeringConnectionRequest.ReadOnly =
    zio.aws.ec2.model.DeleteVpcPeeringConnectionRequest.wrap(buildAwsValue())
}
object DeleteVpcPeeringConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteVpcPeeringConnectionRequest =
      zio.aws.ec2.model.DeleteVpcPeeringConnectionRequest(
        dryRun.map(value => value),
        vpcPeeringConnectionId
      )
    def dryRun: Optional[Boolean]
    def vpcPeeringConnectionId: VpcPeeringConnectionId
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getVpcPeeringConnectionId: ZIO[Any, Nothing, VpcPeeringConnectionId] =
      ZIO.succeed(vpcPeeringConnectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionRequest
  ) extends zio.aws.ec2.model.DeleteVpcPeeringConnectionRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val vpcPeeringConnectionId: VpcPeeringConnectionId =
      zio.aws.ec2.model.primitives
        .VpcPeeringConnectionId(impl.vpcPeeringConnectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionRequest
  ): zio.aws.ec2.model.DeleteVpcPeeringConnectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
