package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTransitGatewayRequest(
    transitGatewayId: TransitGatewayId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRequest = {
    import DeleteTransitGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRequest
      .builder()
      .transitGatewayId(
        TransitGatewayId.unwrap(transitGatewayId): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteTransitGatewayRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTransitGatewayRequest.wrap(buildAwsValue())
}
object DeleteTransitGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTransitGatewayRequest =
      zio.aws.ec2.model.DeleteTransitGatewayRequest(
        transitGatewayId,
        dryRun.map(value => value)
      )
    def transitGatewayId: TransitGatewayId
    def dryRun: Optional[Boolean]
    def getTransitGatewayId: ZIO[Any, Nothing, TransitGatewayId] =
      ZIO.succeed(transitGatewayId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRequest
  ) extends zio.aws.ec2.model.DeleteTransitGatewayRequest.ReadOnly {
    override val transitGatewayId: TransitGatewayId =
      zio.aws.ec2.model.primitives.TransitGatewayId(impl.transitGatewayId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRequest
  ): zio.aws.ec2.model.DeleteTransitGatewayRequest.ReadOnly = new Wrapper(impl)
}
