package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  PrefixListResourceId,
  TransitGatewayRouteTableId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTransitGatewayPrefixListReferenceRequest(
    transitGatewayRouteTableId: TransitGatewayRouteTableId,
    prefixListId: PrefixListResourceId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest = {
    import DeleteTransitGatewayPrefixListReferenceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest
      .builder()
      .transitGatewayRouteTableId(
        TransitGatewayRouteTableId.unwrap(
          transitGatewayRouteTableId
        ): java.lang.String
      )
      .prefixListId(PrefixListResourceId.unwrap(prefixListId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest
      .wrap(buildAwsValue())
}
object DeleteTransitGatewayPrefixListReferenceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest =
      zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest(
        transitGatewayRouteTableId,
        prefixListId,
        dryRun.map(value => value)
      )
    def transitGatewayRouteTableId: TransitGatewayRouteTableId
    def prefixListId: PrefixListResourceId
    def dryRun: Optional[Boolean]
    def getTransitGatewayRouteTableId
        : ZIO[Any, Nothing, TransitGatewayRouteTableId] =
      ZIO.succeed(transitGatewayRouteTableId)
    def getPrefixListId: ZIO[Any, Nothing, PrefixListResourceId] =
      ZIO.succeed(prefixListId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest
  ) extends zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest.ReadOnly {
    override val transitGatewayRouteTableId: TransitGatewayRouteTableId =
      zio.aws.ec2.model.primitives
        .TransitGatewayRouteTableId(impl.transitGatewayRouteTableId())
    override val prefixListId: PrefixListResourceId =
      zio.aws.ec2.model.primitives.PrefixListResourceId(impl.prefixListId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest
  ): zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest.ReadOnly =
    new Wrapper(impl)
}
