package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayPolicyTableId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTransitGatewayPolicyTableRequest(
    transitGatewayPolicyTableId: TransitGatewayPolicyTableId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPolicyTableRequest = {
    import DeleteTransitGatewayPolicyTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPolicyTableRequest
      .builder()
      .transitGatewayPolicyTableId(
        TransitGatewayPolicyTableId.unwrap(
          transitGatewayPolicyTableId
        ): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTransitGatewayPolicyTableRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTransitGatewayPolicyTableRequest
      .wrap(buildAwsValue())
}
object DeleteTransitGatewayPolicyTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPolicyTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTransitGatewayPolicyTableRequest =
      zio.aws.ec2.model.DeleteTransitGatewayPolicyTableRequest(
        transitGatewayPolicyTableId,
        dryRun.map(value => value)
      )
    def transitGatewayPolicyTableId: TransitGatewayPolicyTableId
    def dryRun: Optional[Boolean]
    def getTransitGatewayPolicyTableId
        : ZIO[Any, Nothing, TransitGatewayPolicyTableId] =
      ZIO.succeed(transitGatewayPolicyTableId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPolicyTableRequest
  ) extends zio.aws.ec2.model.DeleteTransitGatewayPolicyTableRequest.ReadOnly {
    override val transitGatewayPolicyTableId: TransitGatewayPolicyTableId =
      zio.aws.ec2.model.primitives
        .TransitGatewayPolicyTableId(impl.transitGatewayPolicyTableId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPolicyTableRequest
  ): zio.aws.ec2.model.DeleteTransitGatewayPolicyTableRequest.ReadOnly =
    new Wrapper(impl)
}
