package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TrafficMirrorTargetId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTrafficMirrorTargetRequest(
    trafficMirrorTargetId: TrafficMirrorTargetId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetRequest = {
    import DeleteTrafficMirrorTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetRequest
      .builder()
      .trafficMirrorTargetId(
        TrafficMirrorTargetId.unwrap(trafficMirrorTargetId): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteTrafficMirrorTargetRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTrafficMirrorTargetRequest.wrap(buildAwsValue())
}
object DeleteTrafficMirrorTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTrafficMirrorTargetRequest =
      zio.aws.ec2.model.DeleteTrafficMirrorTargetRequest(
        trafficMirrorTargetId,
        dryRun.map(value => value)
      )
    def trafficMirrorTargetId: TrafficMirrorTargetId
    def dryRun: Optional[Boolean]
    def getTrafficMirrorTargetId: ZIO[Any, Nothing, TrafficMirrorTargetId] =
      ZIO.succeed(trafficMirrorTargetId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetRequest
  ) extends zio.aws.ec2.model.DeleteTrafficMirrorTargetRequest.ReadOnly {
    override val trafficMirrorTargetId: TrafficMirrorTargetId =
      zio.aws.ec2.model.primitives
        .TrafficMirrorTargetId(impl.trafficMirrorTargetId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetRequest
  ): zio.aws.ec2.model.DeleteTrafficMirrorTargetRequest.ReadOnly = new Wrapper(
    impl
  )
}
