package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SubnetCidrReservationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteSubnetCidrReservationRequest(
    subnetCidrReservationId: SubnetCidrReservationId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationRequest = {
    import DeleteSubnetCidrReservationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationRequest
      .builder()
      .subnetCidrReservationId(
        SubnetCidrReservationId.unwrap(
          subnetCidrReservationId
        ): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteSubnetCidrReservationRequest.ReadOnly =
    zio.aws.ec2.model.DeleteSubnetCidrReservationRequest.wrap(buildAwsValue())
}
object DeleteSubnetCidrReservationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteSubnetCidrReservationRequest =
      zio.aws.ec2.model.DeleteSubnetCidrReservationRequest(
        subnetCidrReservationId,
        dryRun.map(value => value)
      )
    def subnetCidrReservationId: SubnetCidrReservationId
    def dryRun: Optional[Boolean]
    def getSubnetCidrReservationId: ZIO[Any, Nothing, SubnetCidrReservationId] =
      ZIO.succeed(subnetCidrReservationId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationRequest
  ) extends zio.aws.ec2.model.DeleteSubnetCidrReservationRequest.ReadOnly {
    override val subnetCidrReservationId: SubnetCidrReservationId =
      zio.aws.ec2.model.primitives
        .SubnetCidrReservationId(impl.subnetCidrReservationId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationRequest
  ): zio.aws.ec2.model.DeleteSubnetCidrReservationRequest.ReadOnly =
    new Wrapper(impl)
}
