package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteSpotDatafeedSubscriptionRequest(
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest = {
    import DeleteSpotDatafeedSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteSpotDatafeedSubscriptionRequest.ReadOnly =
    zio.aws.ec2.model.DeleteSpotDatafeedSubscriptionRequest
      .wrap(buildAwsValue())
}
object DeleteSpotDatafeedSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteSpotDatafeedSubscriptionRequest =
      zio.aws.ec2.model
        .DeleteSpotDatafeedSubscriptionRequest(dryRun.map(value => value))
    def dryRun: Optional[Boolean]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest
  ) extends zio.aws.ec2.model.DeleteSpotDatafeedSubscriptionRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest
  ): zio.aws.ec2.model.DeleteSpotDatafeedSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
