package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInsightsPathId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteNetworkInsightsPathRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    networkInsightsPathId: NetworkInsightsPathId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsPathRequest = {
    import DeleteNetworkInsightsPathRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsPathRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .networkInsightsPathId(
        NetworkInsightsPathId.unwrap(networkInsightsPathId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteNetworkInsightsPathRequest.ReadOnly =
    zio.aws.ec2.model.DeleteNetworkInsightsPathRequest.wrap(buildAwsValue())
}
object DeleteNetworkInsightsPathRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsPathRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteNetworkInsightsPathRequest =
      zio.aws.ec2.model.DeleteNetworkInsightsPathRequest(
        dryRun.map(value => value),
        networkInsightsPathId
      )
    def dryRun: Optional[Boolean]
    def networkInsightsPathId: NetworkInsightsPathId
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getNetworkInsightsPathId: ZIO[Any, Nothing, NetworkInsightsPathId] =
      ZIO.succeed(networkInsightsPathId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsPathRequest
  ) extends zio.aws.ec2.model.DeleteNetworkInsightsPathRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val networkInsightsPathId: NetworkInsightsPathId =
      zio.aws.ec2.model.primitives
        .NetworkInsightsPathId(impl.networkInsightsPathId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsPathRequest
  ): zio.aws.ec2.model.DeleteNetworkInsightsPathRequest.ReadOnly = new Wrapper(
    impl
  )
}
