package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkAclId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteNetworkAclRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    networkAclId: NetworkAclId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteNetworkAclRequest = {
    import DeleteNetworkAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteNetworkAclRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .networkAclId(NetworkAclId.unwrap(networkAclId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteNetworkAclRequest.ReadOnly =
    zio.aws.ec2.model.DeleteNetworkAclRequest.wrap(buildAwsValue())
}
object DeleteNetworkAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteNetworkAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteNetworkAclRequest =
      zio.aws.ec2.model
        .DeleteNetworkAclRequest(dryRun.map(value => value), networkAclId)
    def dryRun: Optional[Boolean]
    def networkAclId: NetworkAclId
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getNetworkAclId: ZIO[Any, Nothing, NetworkAclId] =
      ZIO.succeed(networkAclId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkAclRequest
  ) extends zio.aws.ec2.model.DeleteNetworkAclRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val networkAclId: NetworkAclId =
      zio.aws.ec2.model.primitives.NetworkAclId(impl.networkAclId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkAclRequest
  ): zio.aws.ec2.model.DeleteNetworkAclRequest.ReadOnly = new Wrapper(impl)
}
