package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NatGatewayId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteNatGatewayRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    natGatewayId: NatGatewayId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteNatGatewayRequest = {
    import DeleteNatGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteNatGatewayRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .natGatewayId(NatGatewayId.unwrap(natGatewayId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteNatGatewayRequest.ReadOnly =
    zio.aws.ec2.model.DeleteNatGatewayRequest.wrap(buildAwsValue())
}
object DeleteNatGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteNatGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteNatGatewayRequest =
      zio.aws.ec2.model
        .DeleteNatGatewayRequest(dryRun.map(value => value), natGatewayId)
    def dryRun: Optional[Boolean]
    def natGatewayId: NatGatewayId
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getNatGatewayId: ZIO[Any, Nothing, NatGatewayId] =
      ZIO.succeed(natGatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNatGatewayRequest
  ) extends zio.aws.ec2.model.DeleteNatGatewayRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val natGatewayId: NatGatewayId =
      zio.aws.ec2.model.primitives.NatGatewayId(impl.natGatewayId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNatGatewayRequest
  ): zio.aws.ec2.model.DeleteNatGatewayRequest.ReadOnly = new Wrapper(impl)
}
