package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteKeyPairResponse(
    returnValue: Optional[Boolean] = Optional.Absent,
    keyPairId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteKeyPairResponse = {
    import DeleteKeyPairResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteKeyPairResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .optionallyWith(keyPairId.map(value => value: java.lang.String))(
        _.keyPairId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteKeyPairResponse.ReadOnly =
    zio.aws.ec2.model.DeleteKeyPairResponse.wrap(buildAwsValue())
}
object DeleteKeyPairResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteKeyPairResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteKeyPairResponse =
      zio.aws.ec2.model.DeleteKeyPairResponse(
        returnValue.map(value => value),
        keyPairId.map(value => value)
      )
    def returnValue: Optional[Boolean]
    def keyPairId: Optional[String]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
    def getKeyPairId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyPairId", keyPairId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteKeyPairResponse
  ) extends zio.aws.ec2.model.DeleteKeyPairResponse.ReadOnly {
    override val returnValue: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.returnValue())
      .map(value => value: Boolean)
    override val keyPairId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPairId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteKeyPairResponse
  ): zio.aws.ec2.model.DeleteKeyPairResponse.ReadOnly = new Wrapper(impl)
}
