package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InternetGatewayId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteInternetGatewayRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    internetGatewayId: InternetGatewayId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteInternetGatewayRequest = {
    import DeleteInternetGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteInternetGatewayRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .internetGatewayId(
        InternetGatewayId.unwrap(internetGatewayId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteInternetGatewayRequest.ReadOnly =
    zio.aws.ec2.model.DeleteInternetGatewayRequest.wrap(buildAwsValue())
}
object DeleteInternetGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteInternetGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteInternetGatewayRequest =
      zio.aws.ec2.model.DeleteInternetGatewayRequest(
        dryRun.map(value => value),
        internetGatewayId
      )
    def dryRun: Optional[Boolean]
    def internetGatewayId: InternetGatewayId
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getInternetGatewayId: ZIO[Any, Nothing, InternetGatewayId] =
      ZIO.succeed(internetGatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteInternetGatewayRequest
  ) extends zio.aws.ec2.model.DeleteInternetGatewayRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val internetGatewayId: InternetGatewayId =
      zio.aws.ec2.model.primitives.InternetGatewayId(impl.internetGatewayId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteInternetGatewayRequest
  ): zio.aws.ec2.model.DeleteInternetGatewayRequest.ReadOnly = new Wrapper(impl)
}
