package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteCoipCidrResponse(
    coipCidr: Optional[zio.aws.ec2.model.CoipCidr] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteCoipCidrResponse = {
    import DeleteCoipCidrResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteCoipCidrResponse
      .builder()
      .optionallyWith(coipCidr.map(value => value.buildAwsValue()))(_.coipCidr)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteCoipCidrResponse.ReadOnly =
    zio.aws.ec2.model.DeleteCoipCidrResponse.wrap(buildAwsValue())
}
object DeleteCoipCidrResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteCoipCidrResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteCoipCidrResponse = zio.aws.ec2.model
      .DeleteCoipCidrResponse(coipCidr.map(value => value.asEditable))
    def coipCidr: Optional[zio.aws.ec2.model.CoipCidr.ReadOnly]
    def getCoipCidr: ZIO[Any, AwsError, zio.aws.ec2.model.CoipCidr.ReadOnly] =
      AwsError.unwrapOptionField("coipCidr", coipCidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteCoipCidrResponse
  ) extends zio.aws.ec2.model.DeleteCoipCidrResponse.ReadOnly {
    override val coipCidr: Optional[zio.aws.ec2.model.CoipCidr.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coipCidr())
        .map(value => zio.aws.ec2.model.CoipCidr.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteCoipCidrResponse
  ): zio.aws.ec2.model.DeleteCoipCidrResponse.ReadOnly = new Wrapper(impl)
}
