package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVerifiedAccessTrustProviderDeviceOptions(
    tenantId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderDeviceOptions = {
    import CreateVerifiedAccessTrustProviderDeviceOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderDeviceOptions
      .builder()
      .optionallyWith(tenantId.map(value => value: java.lang.String))(
        _.tenantId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateVerifiedAccessTrustProviderDeviceOptions.ReadOnly =
    zio.aws.ec2.model.CreateVerifiedAccessTrustProviderDeviceOptions
      .wrap(buildAwsValue())
}
object CreateVerifiedAccessTrustProviderDeviceOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderDeviceOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateVerifiedAccessTrustProviderDeviceOptions =
      zio.aws.ec2.model.CreateVerifiedAccessTrustProviderDeviceOptions(
        tenantId.map(value => value)
      )
    def tenantId: Optional[String]
    def getTenantId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tenantId", tenantId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderDeviceOptions
  ) extends zio.aws.ec2.model.CreateVerifiedAccessTrustProviderDeviceOptions.ReadOnly {
    override val tenantId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tenantId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderDeviceOptions
  ): zio.aws.ec2.model.CreateVerifiedAccessTrustProviderDeviceOptions.ReadOnly =
    new Wrapper(impl)
}
