package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTransitGatewayPolicyTableResponse(
    transitGatewayPolicyTable: Optional[
      zio.aws.ec2.model.TransitGatewayPolicyTable
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPolicyTableResponse = {
    import CreateTransitGatewayPolicyTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPolicyTableResponse
      .builder()
      .optionallyWith(
        transitGatewayPolicyTable.map(value => value.buildAwsValue())
      )(_.transitGatewayPolicyTable)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateTransitGatewayPolicyTableResponse.ReadOnly =
    zio.aws.ec2.model.CreateTransitGatewayPolicyTableResponse
      .wrap(buildAwsValue())
}
object CreateTransitGatewayPolicyTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPolicyTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateTransitGatewayPolicyTableResponse =
      zio.aws.ec2.model.CreateTransitGatewayPolicyTableResponse(
        transitGatewayPolicyTable.map(value => value.asEditable)
      )
    def transitGatewayPolicyTable
        : Optional[zio.aws.ec2.model.TransitGatewayPolicyTable.ReadOnly]
    def getTransitGatewayPolicyTable: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayPolicyTable.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayPolicyTable",
      transitGatewayPolicyTable
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPolicyTableResponse
  ) extends zio.aws.ec2.model.CreateTransitGatewayPolicyTableResponse.ReadOnly {
    override val transitGatewayPolicyTable
        : Optional[zio.aws.ec2.model.TransitGatewayPolicyTable.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayPolicyTable())
        .map(value => zio.aws.ec2.model.TransitGatewayPolicyTable.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPolicyTableResponse
  ): zio.aws.ec2.model.CreateTransitGatewayPolicyTableResponse.ReadOnly =
    new Wrapper(impl)
}
