package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTransitGatewayPeeringAttachmentResponse(
    transitGatewayPeeringAttachment: Optional[
      zio.aws.ec2.model.TransitGatewayPeeringAttachment
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentResponse = {
    import CreateTransitGatewayPeeringAttachmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentResponse
      .builder()
      .optionallyWith(
        transitGatewayPeeringAttachment.map(value => value.buildAwsValue())
      )(_.transitGatewayPeeringAttachment)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentResponse.ReadOnly =
    zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentResponse
      .wrap(buildAwsValue())
}
object CreateTransitGatewayPeeringAttachmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentResponse =
      zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentResponse(
        transitGatewayPeeringAttachment.map(value => value.asEditable)
      )
    def transitGatewayPeeringAttachment
        : Optional[zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly]
    def getTransitGatewayPeeringAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayPeeringAttachment",
      transitGatewayPeeringAttachment
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentResponse
  ) extends zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentResponse.ReadOnly {
    override val transitGatewayPeeringAttachment
        : Optional[zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayPeeringAttachment())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayPeeringAttachment.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentResponse
  ): zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentResponse.ReadOnly =
    new Wrapper(impl)
}
