package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSpotDatafeedSubscriptionRequest(
    bucket: String,
    dryRun: Optional[Boolean] = Optional.Absent,
    prefix: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionRequest = {
    import CreateSpotDatafeedSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateSpotDatafeedSubscriptionRequest.ReadOnly =
    zio.aws.ec2.model.CreateSpotDatafeedSubscriptionRequest
      .wrap(buildAwsValue())
}
object CreateSpotDatafeedSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateSpotDatafeedSubscriptionRequest =
      zio.aws.ec2.model.CreateSpotDatafeedSubscriptionRequest(
        bucket,
        dryRun.map(value => value),
        prefix.map(value => value)
      )
    def bucket: String
    def dryRun: Optional[Boolean]
    def prefix: Optional[String]
    def getBucket: ZIO[Any, Nothing, String] = ZIO.succeed(bucket)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionRequest
  ) extends zio.aws.ec2.model.CreateSpotDatafeedSubscriptionRequest.ReadOnly {
    override val bucket: String = impl.bucket(): String
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val prefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionRequest
  ): zio.aws.ec2.model.CreateSpotDatafeedSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
